﻿
var editor = {
    container: null,
    variableEditorSection: null,
    selectionEditorSection: null,
    numberOfSelection: 0
};


$(document).ready(function () {
    var definition = a4.parent().getSelectionDefinition();
    
    if (!definition) {
        initializeEdition();
    }
    else {
        $.when(a4.callServerMethod(a4.getSurveyAction("SelectionActionEditor", "Questionnaire"), { jsonDefinition: definition },
            function (result) {
                $('.v-actionContent').html(result);                
            })).then(function () {
                initializeEdition();
            });
    }
});

function initializeEdition() {
    a4.top().questionnaireEditor.setRowEvents(document);
        
    editor.container = $(".v-actionContent");
    editor.variableEditorSection = $("#variableSelectionEditor");
    editor.selectionEditorSection = $("#selectionEditor");

    toggleSelectionTableHeader(getDefinedSelections().length > 0);
            
    setEvents();
    setVariableSelection(document);
    a4.top().questionnaireEditor.setValidateNumbersEvents(document);
}


function setVariableSelection(content) {
    $(".v-questionVariable", content).a4autocomplete({
        data: a4.top().questionnaireEditor.variables,
        valueProperty: "value",
        labelProperty: "name",
        tooltipProperty: "questionId",
        tooltipData: function (autocomplete, tooltip, questionId) {
            a4.getTooltipQuestionText(autocomplete, tooltip, a4.top().questionnaireEditor.Id, questionId);
        }
    });
}

function setSelectQuestion(content) {
    $(".v-selectQuestion", content).a4autocomplete({
        data: a4.top().questionnaireEditor.questions,
        valueProperty: "value",
        labelProperty: "name",
        select: function (event, ui) {
            if (ui.item) {
                loadSelectionActions(ui.item.value);
            }
            return false;
        }
    });
}

function loadSelectionActions(questionId) {
    var selectActionDiv = $(".v-selectAction");
    var selectActionSelect = $("select", selectActionDiv);
    selectActionDiv.hide();
    selectActionSelect.empty();
    $(".v-selectedActionResume").empty();
    
    a4.callServerMethod(a4.top().questionnaireEditor.getUrl("GetQuestionSelectionActions"), { questionId: questionId },
        function (result) {
            if (result != undefined) {
                $.each(result, function (key, value) {
                    var label = (value.length >= 70) ? value.substring(0, 67) + "..." : value;
                    selectActionSelect.append($("<option>", { value: key }).text(label));
                });
            }
            if ($("option", selectActionSelect).length > 0) {
                selectActionDiv.show();
                updateSelectedActionResume(selectActionSelect.val());
            }
        });
}

function updateSelectedActionResume(definition) {
    var definitionObjects = jQuery.parseJSON(definition);
    if (definitionObjects != null) {
        var html = $('.v-selectionsText').text() + "<br>";

        for (var i = 0; i < definitionObjects.Selections.length; i++) {
            html += definitionObjects.Selections[i].Value + "<br>";
        }

        if (definitionObjects.Variables.length > 0) {
            html += "<br>" + $('.v-assignedVariablesText').text() + "<br>";

            for (var i = 0; i < definitionObjects.Variables.length; i++) {
                html += definitionObjects.Variables[i].VariableName + "<br>";
            }
        }

        $(".v-selectedActionResume").html(html);
    }
}

function setEvents() {
    $(".v-addVariableRow").on('click', function () {
        var variableName = $(".v-questionVariable", editor.variableEditorSection).val().toUpperCase();

        if (variableName.length > 0) {
            addVariableRow(variableName, 1);
        }
    });

    $(".v-addSelectionRow").on('click', function () {
        addSelectionRow();        
    });

    $(".h-deleteRow").on('click', function () {        
        toggleSelectionTableHeader(getDefinedSelections().length > 1);
    });

    $(".v-addMultipleSelectionRow").on('click', function () {
        var textarea = $('<textarea style="height:' + ($(window).height() / 2.5) + 'px; max-height:8em; width:' + ($(window).width() / 2) + 'px; max-width:400px;"></textarea>').val(getSelectionDefinitionInTextFormat());
        var content = $('<div id="SelectionEditorDialog">').append(textarea);
        var addMultipleResources = { "Title": resources.AddEditMultiple, "Message": content };

        modalDialog.showConfirmDialog(addMultipleResources,
            function () {
                var rows = $.map($('textarea', content).val().split('\n'), function (row) { return stringToSelectionObject(row); });
                $(".v-selectionListTableBody", editor.container).html("");
                setSelectionFromDefinition(rows);
            }, 400, 600);
    });

    $(".v-addFromOtherSelectionRow").on('click', function () {
        var selectQuestion = $('<div>').append($('<div>' + $('.v-selectQuestionText', editor.container).text() + '</div>')).append('<input type="text" class="v-selectQuestion" />');
        var selectAction = $('<div class="hidden v-selectAction">').append($('<div>' + $('.v-selectActionText', editor.container).text() + '</div>')).append('<select>');
        var content = $('<div id="SelectionEditorDialog">').append(selectQuestion).append(selectAction).append('<div class="v-selectedActionResume">');
        var addMultipleResources = { "Title": resources.AddFromOtherSelection, "Message": content };

        modalDialog.showConfirmDialog(addMultipleResources,
            function () {
                var selection = $('.v-selectAction select', content).val();

                if (selection && selection != "") {
                    addSelectionDefinitionRows(selection);
                }
            }, 400, 600, null, null, { initFunction: function () { setSelectQuestion(content) } });
    });


    $(".v-addFromVariableSelectionRow").on('click', function () {
        var autocomplete = $('<input type="text" class="v-questionVariable" style="width:90%;" />');
        var content = $('<div id="SelectionEditorDialog">').append($('<div>' + $('.v-selectVariableText', editor.container).text() + '</div>')).append(autocomplete);
        var addMultipleResources = { "Title": resources.AddFromVariableChoices, "Message": content };

        modalDialog.showConfirmDialog(addMultipleResources,
            function () {
                var variable = $(':text', content).val();

                if (variable && variable != "") {
                    addVariableChoicesRows(variable);
                }
            }, 400, 600, null, null, { initFunction: function () { setVariableSelection(content) } });
    });

    $("#submit").on("click", function () {
        var definition = getSelectionDefinitionObject();
        a4.parent().validateSelectionActions(JSON.stringify(definition));
    });
}

function addSelectionDefinitionRows(definition) {
    var definitionObjects = jQuery.parseJSON(definition);
    if (definitionObjects != null) {
        setSelectionFromDefinition(definitionObjects.Selections);
    }
}

function addVariableChoicesRows(variable) {    
    a4.callServerMethod(a4.top().questionnaireEditor.getUrl("GetVariableChoiceValues"), { variableName: variable },
        function (result) {
            $.each(result, function (index, value) {
                if (jQuery.trim(value) != "") {
                    $(".v-addSelectionRow", editor.selectionEditorSection).trigger("click");
                    $(".v-selectionListTableBody tr:last .v-value", editor.selectionEditorSection).val(value);
                }
            });
        });
}

function addVariableRow(variableName, variableMention) {
    var variableRow = $(".v-newVariable tr.v-variableRow", editor.variableEditorSection).clone(false);

    $(".v-variableColumn", variableRow).append(variableName);
    $(".v-mentionColumn .v-mentionTextBox", variableRow).val(variableMention);

    $(variableRow).appendTo($("table .v-variableListTableBody", editor.variableEditorSection));
}

function toggleSelectionTableHeader(show)
{    
    $(".selectionValueColumn").toggle(show);
    $(".selectionInclusionFormulaColumn").toggle(show);
    $(".selectionPriorityColumn").toggle(show);
    $(".selectionScoreFormulaColumn").toggle(show);
    $(".selectionEditionColumn").toggle(show);
}
function addSelectionRow() {               
    
    var selectionRow = $(".v-newSelection .v-newSelectionBody tr", editor.selectionEditorSection).clone(false);
    $(selectionRow).appendTo($("table .v-selectionListTableBody", editor.selectionEditorSection));

    $(".h-deleteRow", selectionRow).on('click', function () {
        toggleSelectionTableHeader(getDefinedSelections().length > 1);
    });

    toggleSelectionTableHeader(true);

    editor.numberOfSelection++;
    return selectionRow;
}

function setSelectionFromDefinition(selectionObjects) {
    for (var i = 0; i < selectionObjects.length; i++) {
        var selection = selectionObjects[i];
        var selectionRow = addSelectionRow();

        $(".v-value", selectionRow).val(selection.Value);
        $(".v-inclusionFormula", selectionRow).val(selection.InclusionFormula);
        $(".v-priority", selectionRow).val(selection.Priority);
        $(".v-scoreFormula", selectionRow).val(selection.ScoreFormula);
    }    
}


function getDefinedVariables() {
    return $(editor.variableEditorSection).find(".v-variableListTable .v-variableListTableBody tr:visible").map(function () { return newVariable($(this)); }).get();
}

function newVariable(variableRow) {
    var variableDef = {};
    variableDef.VariableName = $(".v-variableColumn", variableRow).html();
    variableDef.Mention = $(".v-mentionColumn .v-mentionTextBox", variableRow).val();
    return variableDef;
}

function getDefinedSelections() {
    return $(editor.selectionEditorSection).find(".v-selectionListTable .v-selectionListTableBody tr:visible").map(function () { return newSelection($(this)); }).get();
}

function newSelection(selectionRow) {
    var selectionDef = {};
    selectionDef.Value = $(".v-value", selectionRow).val();
    selectionDef.InclusionFormula = $(".v-inclusionFormula", selectionRow).val().replace(/([^])(<)([a-zA-Z0-9])/g, "$1 $2 $3");
    selectionDef.Priority = $(".v-priority", selectionRow).val();
    selectionDef.ScoreFormula = $(".v-scoreFormula", selectionRow).val().replace(/([^])(<)([a-zA-Z0-9])/g, "$1 $2 $3");

    return selectionDef;
}

function getSelectionDefinitionInTextFormat() {
    var result = "";
    $(editor.selectionEditorSection).find(".v-selectionListTable .v-selectionListTableBody tr:not(.deleted)").map(
                function () {
                    result = result
                            + $(".v-value", this).val() + ";"
                            + $(".v-inclusionFormula", this).val() + ";"
                            + $(".v-priority", this).val() + ";"
                            + $(".v-scoreFormula", this).val()
                            + "\n";
                });

    if (result.length > 0) {
        result = result.substring(0, result.length - 1);
    } // flush last \n for slip

    return result;
}

function stringToSelectionObject(selectionString) {
    var values = selectionString.split(';');
    var selectionDef = {};
    selectionDef.Value = values[0];
    selectionDef.InclusionFormula = values[1];
    selectionDef.Priority = values[2];
    selectionDef.ScoreFormula = values[3];
    return selectionDef;
}

function getSelectionDefinitionObject() {
    var selectionDefinition = {};
    selectionDefinition.Variables = getDefinedVariables();
    selectionDefinition.Selections = getDefinedSelections();
    return selectionDefinition;
}


